/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.animation;

import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.q_misc_util.my_util.LimitedLogger;

@OnlyIn(value=Dist.CLIENT)
public class StableClientTimer {
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);
    private static boolean initialized = false;
    @Nullable
    private static Time stableTime = null;
    @Nullable
    private static Time offsetTime = null;
    private static long referenceTickTime = 0L;
    private static double timeFlowScale = 1.0;
    @Nullable
    private static double debugOffset;

    public static void init() {
        IPGlobal.clientCleanupSignal.connect(StableClientTimer::cleanup);
    }

    public static long getStableTickTime() {
        if (stableTime == null) {
            return 0L;
        }
        return StableClientTimer.stableTime.tickTime;
    }

    public static float getStablePartialTicks() {
        if (stableTime == null) {
            return 0.0f;
        }
        return StableClientTimer.stableTime.partialTicks;
    }

    private static void cleanup() {
        initialized = false;
        stableTime = null;
        offsetTime = null;
    }

    private static void reset(long worldGameTime, float partialTicks) {
        timeFlowScale = 1.0;
        stableTime = new Time(worldGameTime, partialTicks);
        Time referenceTime = new Time(referenceTickTime, partialTicks);
        offsetTime = stableTime.subtracted(referenceTime);
    }

    public static void tick() {
        ++referenceTickTime;
    }

    public static void update(long worldGameTime, float partialTicks) {
        Time serverSyncedTime;
        if (!initialized) {
            initialized = true;
            StableClientTimer.reset(worldGameTime, partialTicks);
            return;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        Validate.notNull((Object)stableTime);
        Validate.notNull((Object)offsetTime);
        Time lastStableTime = stableTime;
        Time referenceTime = new Time(referenceTickTime, partialTicks);
        Time targetTime = serverSyncedTime = new Time(worldGameTime, partialTicks);
        Time projectedStableTime = referenceTime.added(offsetTime);
        double deltaTickTime = targetTime.subtractedLen(projectedStableTime);
        double stableTimeDelta = projectedStableTime.subtractedLen(lastStableTime);
        if (stableTimeDelta < 0.0) {
            return;
        }
        if (deltaTickTime < 0.0) {
            double targetSubtractLastStable = targetTime.subtractedLen(lastStableTime);
            if (targetSubtractLastStable < 0.0) {
                if (targetSubtractLastStable < -100.0) {
                    StableClientTimer.reset(worldGameTime, partialTicks);
                    limitedLogger.err("Reset the client stable timer because the target time is too far behind");
                } else {
                    if (timeFlowScale > 1.0) {
                        timeFlowScale = 1.0;
                    }
                    stableTime = lastStableTime.added((float)((timeFlowScale *= 0.9999) * stableTimeDelta));
                    offsetTime = stableTime.subtracted(referenceTime);
                }
            } else {
                stableTime = targetTime;
                offsetTime = stableTime.subtracted(referenceTime);
                timeFlowScale = 1.0;
            }
        } else {
            if (timeFlowScale < 1.0) {
                timeFlowScale = 1.0;
            }
            stableTime = lastStableTime.added((float)((timeFlowScale *= 1.0001) * stableTimeDelta));
            offsetTime = stableTime.subtracted(referenceTime);
        }
        debugOffset = targetTime.subtractedLen(stableTime);
    }

    public static String getDebugString() {
        double shownOffset = debugOffset;
        if (Math.abs(shownOffset) < 1.0E-4) {
            shownOffset = 0.0;
        }
        return String.format("Stable Timer Offset %.3f", shownOffset);
    }

    public static final class Time {
        final long tickTime;
        final float partialTicks;

        Time(long tickTime, float partialTicks) {
            this.tickTime = tickTime;
            this.partialTicks = partialTicks;
        }

        Time normalized() {
            int fullTicks;
            long tickTime = this.tickTime;
            float partialTicks = this.partialTicks;
            if (partialTicks < 0.0f) {
                fullTicks = (int)Math.floor(partialTicks);
                partialTicks -= (float)fullTicks;
                tickTime += (long)fullTicks;
            }
            if (partialTicks >= 1.0f) {
                fullTicks = (int)partialTicks;
                partialTicks -= (float)fullTicks;
                tickTime += (long)fullTicks;
            }
            return new Time(tickTime, partialTicks);
        }

        double subtractedLen(Time another) {
            return (float)(this.tickTime - another.tickTime) + this.partialTicks - another.partialTicks;
        }

        Time subtracted(Time another) {
            return new Time(this.tickTime - another.tickTime, this.partialTicks - another.partialTicks).normalized();
        }

        Time added(Time another) {
            return new Time(this.tickTime + another.tickTime, this.partialTicks + another.partialTicks).normalized();
        }

        Time added(float delta) {
            return new Time(this.tickTime, this.partialTicks + delta).normalized();
        }

        public String toString() {
            return "%d+%.3f".formatted(this.tickTime, Float.valueOf(this.partialTicks));
        }
    }
}

